/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "fsl_os_abstraction.h"


#include "fsl_enet_driver.h"
#include "fsl_clock_manager.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/
#define ENET_INSTANCE      0U

/*******************************************************************************
 * Code
 ******************************************************************************/

#if (FSL_RTOS_MQX)
/* MQX RTOS require instalation of interrupt handlers. */
void MQX_ENET_Transmit_IRQHandler(void)
{
     ENET_DRV_TxIRQHandler(ENET_INSTANCE);
}

void MQX_ENET_Receive_IRQHandler(void)
{
     ENET_DRV_RxIRQHandler(ENET_INSTANCE);
}

#if FSL_FEATURE_ENET_SUPPORT_PTP
void MQX_ENET_1588_Timer_IRQHandler(void)
{
     ENET_DRV_TsIRQHandler(ENET_INSTANCE);
}
#endif

#else /* FSL_RTOS_MQX */
void ENET_Transmit_IRQHandler(void)
{
     ENET_DRV_TxIRQHandler(ENET_INSTANCE);
}

void ENET_Receive_IRQHandler(void)
{
     ENET_DRV_RxIRQHandler(ENET_INSTANCE);
}

#if FSL_FEATURE_ENET_SUPPORT_PTP
void ENET_1588_Timer_IRQHandler(void)
{
     ENET_DRV_TsIRQHandler(ENET_INSTANCE);
}
#else
void ENET_1588_Timer_IRQHandler(void)
{
}
#endif
#endif /* FSL_RTOS_MQX */

/*******************************************************************************
 * EOF
 ******************************************************************************/

